﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;

namespace OTOM
{
    public class ObjectMapper
    {
        public static String map(List<PropertyPair> pairs, Type source, Type destination)
        {
            return map(pairs, source, destination, false);
        }

        public static String map(List<PropertyPair> pairs, Type source, Type destination, bool mapOpposite)
        {
            StringBuilder sb = new StringBuilder();            

            sb.AppendLine("public static " + destination.Namespace + "." + destination.Name + " map(" + source.Namespace + "." + source.Name + " " + getVar(source.Name) + ")");
            sb.AppendLine("{");
            sb.AppendLine("\t" + destination.Namespace + "." + destination.Name + " " + getVar(destination.Name) + " = new " + destination.Namespace + "." + destination.Name + "();");
            sb.AppendLine();
            foreach (PropertyPair p in pairs)
            {
                sb.AppendLine("\t" + getVar(destination.Name) + "." + p.Destination.Name + " = " + getVar(source.Name) + "." + p.Source.Name + ";");
            }
            sb.AppendLine();
            sb.AppendLine("\t" + "return " + getVar(destination.Name) + ";");
            sb.AppendLine("}");

            if (mapOpposite)
            {
                sb.AppendLine();
                sb.AppendLine();

                List<PropertyPair> secondPairs = new List<PropertyPair>(pairs.Count);

                foreach (PropertyPair pair in pairs)
                {
                    secondPairs.Add(new PropertyPair(pair.Destination, pair.Source));
                }

                sb.AppendLine(map(secondPairs, destination, source, false));
            }

            return sb.ToString();
        }

        private static String getVar(String name)
        {
            return name.Substring(0, 1).ToLower() + (name.Length > 1 ? name.Substring(1) : String.Empty);
        }
    }
}