﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;

namespace OTOM
{
    public class ClassInfo
    {
        public static Type[] getTypesFromAssembly(String assemblyPath)
        {
            Assembly asy = Assembly.LoadFrom(assemblyPath);

            return asy.GetTypes();
        }

        public static PropertyInfo[] getProperties(Type type)
        {
            return type.GetProperties();
        }

        public static PropertyInfo getPropertyByName(String assemblyPath, String type, String targetProperty)
        {
            Type objectType = getTypeByName(assemblyPath, type);

            foreach (PropertyInfo p in objectType.GetProperties())
            {
                if (p.Name.Equals(targetProperty))
                {
                    return p;
                }
            }

            throw new Exception("Unable to find property [" + targetProperty + "] in type [" + type + "]");
        }

        public static Type getTypeByName(String assemblyPath, String type)
        {
            Assembly assembly = Assembly.LoadFrom(assemblyPath);

            return assembly.GetType(type);
        }

        public static Assembly getAssemblyByProperty(PropertyInfo propertyInfo)
        {
            return propertyInfo.DeclaringType.Assembly;
        }
    }
}