﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Runtime.Serialization.Formatters.Binary;

namespace OTOM
{
    [Serializable()]
    public class Mapping
    {
        private AssemblyMapping sourceAssembly;
        private AssemblyMapping destinationAssembly;
        private List<PropertyMapping> propertyPairs = new List<PropertyMapping>();

        public OTOM.AssemblyMapping SourceAssembly
        {
            get { return this.sourceAssembly; }
            set { this.sourceAssembly = value; }
        }

        public OTOM.AssemblyMapping DestinationAssembly
        {
            get { return this.destinationAssembly; }
            set { this.destinationAssembly = value; }
        }

        public System.Collections.Generic.List<OTOM.PropertyMapping> PropertyPairs
        {
            get { return this.propertyPairs; }
            set { this.propertyPairs = value; }
        }

        public void SaveToDisk(String path)
        {
            FileStream fs = new FileStream(path, FileMode.Create);

            BinaryFormatter bf = new BinaryFormatter();
            bf.Serialize(fs, this);

            fs.Flush();
            fs.Close();
        }

        public static Mapping LoadFromDisk(String path)
        {
            FileStream fs = new FileStream(path, FileMode.Open);

            BinaryFormatter bf = new BinaryFormatter();

            object o = (Mapping)bf.Deserialize(fs);

            fs.Close();

            if (!(o is Mapping))
            {
                throw new ArgumentException("The file specified is not a OTOM mapping file.");
            }
            else
            {
                return (Mapping)o;
            }
        }
    }
}